numTraps = 5
timer = 0
bullets = {}
makeOrange = false
radius = {}
attack = false

function Update()
    if timer == 0 then
        InitializeRadius()
    end
    timer = timer + 1
    if not attack then
        if timer <= 60 * numTraps then
            CreateTrap()
        elseif timer == 60 * numTraps + 31 then
            Audio.PlaySound("mus_sfx_eyeflash")
        elseif timer > 60 * numTraps + 60 then
            timer = 0
            attack = true
        end
    elseif timer <= 60 * numTraps then
        MoveBullets()
        if timer % 60 == 40 and timer <= 60 * (numTraps - 1) then
            Encounter.Call("InvertPlayer")
        end
    else
        EndWave()
    end
end

function InitializeRadius()
    local ordered = {}
    for i = 1, numTraps do
        table.insert(ordered, 100 + 6 * (i - 1))
    end
    while #ordered > 0 do
        table.insert(radius, table.remove(ordered, math.random(#ordered)))
    end
end

function CreateTrap()
    if timer % 60 == 1 then
        makeOrange = math.random(2) == 1
    end
    local whichTrap = math.floor((timer - 1) / 60) + 1
    local trapRadius = radius[whichTrap]
    local angle = 2 * math.pi * ((timer % 60) / 60)
    local x = trapRadius * math.cos(angle)
    local y = trapRadius * math.sin(angle)
    local bullet = CreateProjectile('pellet', x, y)
    bullet.SetVar('speedX', -x / 10)
    bullet.SetVar('speedY', -y / 10)
    bullet.sprite.SetAnimation({'pellet', 'pellet'}, 1 / 12)
    if makeOrange then
        bullet.sprite.color = {255/255, 154/255, 34/255}
        bullet.SetVar('orange', true)
    else
        bullet.sprite.color = {0/255, 162/255, 232/255}
        bullet.SetVar('orange', false)
    end
    table.insert(bullets, bullet)
    if timer % 2 == 0 then
        Audio.PlaySound("pellet")
    end
end

function MoveBullets()
    limit = 60 * math.floor((timer - 1) / 60) + 60
    for i = 1, limit do
        local bullet = bullets[i]
        local speedX = bullet.GetVar('speedX')
        local speedY = bullet.GetVar('speedY')
        bullet.Move(speedX, speedY)
    end
end

function OnHit(bullet)
    if (Player.isMoving == bullet.GetVar('orange')) != Encounter.GetVar("playerInvert") then
        return
    end
    local damage = Player.hp - 1
    if damage > 1 then
        damage = 5
    elseif damage < 1 then
        damage = 1
    end
    Player.Hurt(damage)
end
